<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Intercoom
 */

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('article_wrap is_post'); ?>>
    <div class="column-12 column-mob-12 column-tab-12 column-tab-big-12">
    <div class="post_thumb">
            <?php the_post_thumbnail(); ?>
        </div>
        <div class="product_content">
            <h1><?php the_title(); ?></h1>
            <div class="content_wrap"><?php the_content(); ?></div>
            <ul class="share_product">
                <li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="_blank"><span aria-hidden="true" class="social_facebook_circle"></span></a></li>
                <li><a href="https://twitter.com/intent/tweet?url=<?php the_permalink();?>&via=intercoom&text=<?php the_title();?>" target="_blank"><span aria-hidden="true" class="social_twitter_circle"></span></a></li>
                <li><a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>&summary=<?php echo limit(wp_strip_all_tags(get_the_content()),150); ?>&source=https//intercoom.com" target="_blank"><span aria-hidden="true" class="social_linkedin_circle"></span></a></li>
            </ul>
        </div>
    </div>
</article><!-- #post-## -->
