<?php
/**
 * Template part for displaying a message that posts cannot be found.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Intercoom
 */

?>

<section class="page_container">
<div class="section_headline">
		<h1 class="page-title"><?php esc_html_e( 'Nuk ka rezultat', 'intercoom' ); ?></h1>
	</div>
<div class="container_clear">
		<div class="container has_gutter">
		<div class="page_content">

		<?php
		if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<h2><?php printf( wp_kses( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'intercoom' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( 'post-new.php' ) ) ); ?></h2>

		<?php elseif ( is_search() ) : ?>

			<h2><?php esc_html_e( 'Nuk ka rezultat, kërkoni përsëri me ndonjë fjalë kyce tjetër', 'intercoom' ); ?></h2>
			<?php
			echo '<div class="search_page_wrap">';
				get_search_form();
			echo '</div>';

		else : ?>

			<h2><?php esc_html_e( 'Nuk ka rezultat, kërkoni përsëri me ndonjë fjalë kyce tjetër. ', 'intercoom' ); ?></h2>
			<?php
				echo '<div class="search_page_wrap">';
				get_search_form();
			echo '</div>';

		endif; ?>
			</div>
			</div>
		</div>
	</section><!-- #primary -->