(function($, window, document) {
    "use strict";
    $(function() {
        //##Variables
        var $body = $('body'),
            $window = $(window),
            $doc = $(document),
            $heroSlider = $('#hero_slider').find('.owl-carousel'),
            $brandsSlider = $('#brands_slider').find('.owl-carousel'),
            $aboutSlider = $('#about_slider').find('.owl-carousel'),
            $navToggle = $('#nav_toggle'),
            $primaryNav = $('.primary_navigation'),
            $header = $('.home #header'),
            $bannerContent = $('.slider_content'),
            $searchToggle = $('#search_toggle'),
            $searchWrap = $('.search_wrap'),
            $brandGrid = $('#brand_grid'),
            $productGallery = $('#product_carousel').find('.owl-carousel'),
            mobile = Modernizr.mq('(max-width: 767px)'),
            headerClass = 'header_active',
            searchClass = 'search_active',
            navToggleActiveClass = 'is-active',
            defaultEasing = [0.4, 0.0, 0.2, 1];
        //End Variables
        //Functions
        $doc.scroll(function() {
            if ($doc.scrollTop() >= 50) {
                // user scrolled 50 pixels or more;
                // do stuff
                $header.addClass(headerClass);
            } else {
                $header.removeClass(headerClass);
            }
            $bannerContent.css("opacity", 1 - $doc.scrollTop() / 280);
        });
        //Nav Open
        $navToggle.click(function(e) {
            e.preventDefault();
            $(this).toggleClass('is-active');
            $primaryNav.toggleClass('open');
        });
        //src toggle
        $searchToggle.click(function(event) {
            event.preventDefault();
            $searchWrap.toggleClass(searchClass);
        });
        $doc.keyup(function(e) {
            if (e.keyCode == 27) {
                $searchWrap.removeClass(searchClass);
            }
        });
        $doc.mouseup(function(e) {
            if ($searchWrap.length > 0) {
                var container = $searchWrap.find('.search_form');
                if (!container.is(e.target) && container.has(e.target).length === 0) {
                    $searchWrap.removeClass(searchClass);
                }
            }
        });
        //Init Plugins
        $heroSlider.owlCarousel({
            nav: true,
            loop: true,
            autoplay: true,
            items: 1,
            autoplayTimeout: 9000,
            navText: ['', '']
        });
        $brandsSlider.owlCarousel({
            nav: false,
            loop: true,
            center: true,
            autoplay: true,
            items: 4,
            autoplayTimeout: 9000,
            navText: ['', ''],
            responsiveClass: true,
            responsive: {
                0: {
                    items: 2,
                },
                768: {
                    items: 3,
                },
                1024: {
                    items: 4,
                }
            }
        });
        $aboutSlider.owlCarousel({
            nav: true,
            loop: true,
            autoplay: true,
            items: 1,
            autoplayTimeout: 9000,
            navText: ['', '']
        });
        if($('.home .sale_section .is-sale').length < 1) {
            $('.home .sale_section').remove();
        }
        //Smoothscroll
        if (!mobile) {
            // SmoothScroll({ stepSize: 30 })
        }
        //Grid
        $brandGrid.isotope({
            itemSelector: '.grid-item',
            percentPosition: true,
            masonry: {
                // set to the element
                columnWidth: '.grid-item'
            },
            hiddenStyle: {
                opacity: 0
            },
            visibleStyle: {
                opacity: 1
            }
        });
        var filters = {};
        $('.brand_filter').on('click', 'a', function(e) {
            e.preventDefault();
            var $this = $(this);
 /*           $('.brand_filter a').parent().removeClass('active_filter');
            $this.parent().addClass('active_filter');*/
            var $buttonGroup = $this.parent().parent('.brand_filter');
            var filterGroup = $buttonGroup.attr('data-filter-group');
            // set filter for group
            filters[filterGroup] = $this.attr('data-filter');
            // combine filters
            var filterValue = concatValues(filters);
            $brandGrid.isotope({ filter: filterValue });
        });
        // change is-checked class on buttons
        $('.brand_filter').each(function(i, buttonGroup) {
            var $buttonGroup = $(buttonGroup);
            $buttonGroup.on('click', 'a', function() {
                $buttonGroup.find('.active_filter').removeClass('active_filter');
                $(this).addClass('active_filter');
            });
        });

        // flatten object by concatting values
        function concatValues(obj) {
            var value = '';
            for (var prop in obj) {
                value += obj[prop];
            }
            return value;
        }

        //Gallery
        $productGallery.owlCarousel({
            items: 1,
            nav: false,
            dots: false,
            thumbs: true,
            thumbsPrerendered: true
        });
        //WowJS 
        new WOW().init();
    });
}(window.jQuery, window, document));
