<?php get_header(); ?>
<!-- SINGLE PRODUCT -->

<section class="single_product_section wow fadeInUp" data-wow-delay="100ms">
    <div class="container_clear">
        <div class="container has_gutter">
            <div class="row">
            <?php while ( have_posts() ) : the_post(); 
                $postID = $post->ID;
                $price = get_field('cmimi');
                $barcode = get_field('barkodi');
                $salePrice = get_field('cmimi_ne_zbritje');
                $isSale = get_field('eshte_ne_zbritje');
            ?>
				<article id="product-<?php the_ID(); ?>" <?php post_class('article_wrap'); ?>>
				    <div class="column-5 column-mob-12 column-tab-6 column-tab-big-4">
				        <div class="product_gallery">
				            <div class="prod-carousel" id="product_carousel">
				                <div class="owl-carousel" data-slider-id="1">
				                    <div>
				                        <div class="product_gallery_thumb"><?php the_post_thumbnail('500x500') ?></div>
				                    </div>
									<?php if( have_rows('fotografite_e_produktit') ): ?>
									<?php while ( have_rows('fotografite_e_produktit') ) : the_row(); 
										$extraImg = get_sub_field('fotografia_e_produktit');
										$extraImgBig = '500x500';
                   						$imgBig = $extraImg['sizes'][$extraImgBig];
									?>
				                    <div>
				                       <div class="product_gallery_thumb"><img src="<?php echo esc_url($imgBig); ?>" alt="<?php the_title(); ?>"></div>
				                    </div>	
				                    <?php 
				                    endwhile;
									endif; ?>	                   
				                </div>
				            </div>
				            <div class="owl-thumbs" data-slider-id="1">
				                <a href="#" class="owl-thumb-item"><?php the_post_thumbnail('100x100') ?></a>
				                <?php if( have_rows('fotografite_e_produktit') ): ?>
									<?php while ( have_rows('fotografite_e_produktit') ) : the_row(); 
										$extraImg = get_sub_field('fotografia_e_produktit');
										$extraImgSmall = '100x100';
                   						$imgSmall = $extraImg['sizes'][$extraImgSmall];
									?>
				                <a href="#" class="owl-thumb-item"><img src="<?php echo esc_url($imgSmall); ?>" alt="<?php the_title(); ?>"></a>
				                <?php 
				                    endwhile;
									endif; ?>
				            </div>
				        </div>
				    </div>
				    <div class="column-7 column-mob-12 column-tab-6 column-tab-big-8">
				        <div class="product_content">
				            <h1><?php the_title(); ?></h1>

				            <h3>Detajet e Produktit</h3>
                            <?php if($price || $barcode){ ?>
                            <div class="intro_details">
                                <ul>
                                        <?php if(!$isSale){ ?>
                                        <?php if($price){ ?>
                                            <li><h5>Çmimi: </h5><span><?php echo $price ?>&euro;</span></li>
                                         <?php } ?>   
                                         <?php } else { ?>
                                         <?php if($price){ ?>
                                            <li><h5>Çmimi: </h5><span><strike><?php echo $price ?></strike><span class="price_sale"><?php echo $salePrice ?>&euro;</span></span></li>
                                         <?php } ?>   
                                         <?php } ?>
                                         <?php if($barcode){ ?>
                                            <li><h5>Barkodi: </h5><span><?php echo $barcode; ?></span></li>
                                        <?php } ?>
                                            
                                        </ul>
                            </div>
                            <?php } ?>
				            <div class="content_wrap"><?php the_content(); ?></div>
                                <?php if( have_rows('more_details') ): ?>
                            <ul class="extra_details">
                                <?php 
                                    while ( have_rows('more_details') ) : the_row(); 
                                        $detailTitle = get_sub_field('titulli_i_detajit');
                                        $detailValue = get_sub_field('vlera_e_detajit');
                                ?>
                                <li><h5><?php echo $detailTitle; ?>:</h5><span><?php echo $detailValue; ?></span></li>
                               <?php endwhile; ?>
                            </ul>
                            <?php endif; ?>
				            <ul class="share_product">
				                <li><a href="<?php echo esc_url('https://www.facebook.com/sharer/sharer.php?u='.get_the_permalink())?>" target="_blank"><span aria-hidden="true" class="social_facebook_circle"></span></a></li>
				                <li><a href="<?php echo esc_url('https://twitter.com/intent/tweet?url='.the_permalink().'&via=intercoom&text='.get_the_title()) ?>" target="_blank"><span aria-hidden="true" class="social_twitter_circle"></span></a></li>
				                <li><a href="<?php echo esc_url('https://www.linkedin.com/shareArticle?mini=true&url='.get_the_permalink().'&title='.get_the_title().'&source=https//intercoom.com') ?>" target="_blank"><span aria-hidden="true" class="social_linkedin_circle"></span></a></li>
				            </ul>
				        </div>
				    </div>
				</article>
			<?php endwhile; ?>
            <?php wp_reset_query(); ?>
            </div>
        </div>
    </div>
</section>
<!-- /SINGLE PRODUCT -->
<!-- RELATED PRODUCT -->
<section class="related_section wow fadeIn" data-wow-delay="400ms">
    <div class="container has_gutter">
        <h2 class="related_title">Te Ngjashme</h2>
        <div class="row">
            <?php 
                $terms = get_the_terms( $post->ID , 'kategoria_e_produktit', 'string');
                //Pluck out the IDs to get an array of IDS
                $term_ids = wp_list_pluck($terms,'term_id');
                $args = array(
                    'post_type'=>'produktet',
                    'tax_query' => array(
                    array(
                        'taxonomy' => 'kategoria_e_produktit',
                        'field' => 'id',
                        'terms' => $term_ids,
                        'operator'=> 'AND' //Or 'AND' or 'NOT IN'
                     )),
                    'posts_per_page'=>3,
                    'post__not_in' => array($post->ID)
                );
                $i = 0;
                $prodLoop = new WP_Query( $args );
                while ( $prodLoop->have_posts() ) : $prodLoop->the_post(); $i++;
                $catSlug = get_the_terms( get_the_id(), 'kategoria_e_produktit' );
                            $brendSlug = get_the_terms( get_the_id(), 'brend' );
                            $price = get_field('cmimi');
                            $barcode = get_field('barkodi');
                            $salePrice = get_field('cmimi_ne_zbritje');
                            $isSale = get_field('eshte_ne_zbritje');
                        ?>
                     <?php if($isSale){ ?>
                            <div class="column-3 column-mob-12 column-tab-6 column-tab-big-6 is-sale grid-item <?php echo $catSlug[0]->slug ?> <?php echo $brendSlug[0]->slug ?>">
                        <?php } else {  ?>
                            <div class="column-3 column-mob-12 column-tab-6 column-tab-big-6 grid-item <?php echo $catSlug[0]->slug ?> <?php echo $brendSlug[0]->slug ?>">
                        <?php } ?>
                                <article class="brand_item">
                                    <div class="brand_holder">
                                    <?php if($isSale){ echo '<span class="zbritje-tag">Zbritje</span>'; }?>
                                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('350x350'); ?></a>
                                    </div>
                                    <div class="brand_content">
                                    <a href="<?php the_permalink(); ?>">
                                        <h4><?php the_title(); ?></h4>
                                        <p><?php echo limit(wp_strip_all_tags(get_the_content()),117) ?></p>
                                        <ul>
                                        <?php if(!$isSale){ ?>
                                        <?php if($price){ ?>
                                            <li><h5>Çmimi</h5><span><?php echo $price ?>&euro;</span></li>
                                         <?php } ?>   
                                         <?php } else { ?>
                                         <?php if($price){ ?>
                                            <li><h5>Çmimi</h5><span><strike><?php echo $price ?></strike><span class="price_sale"><?php echo $salePrice ?>&euro;</span></span></li>
                                         <?php } ?>   
                                         <?php } ?>
                                         <?php if($barcode){ ?>
                                            <li><h5>Barkodi</h5><span><?php echo $barcode; ?></span></li>
                                        <?php } ?>
                                            
                                        </ul>
                                        </a>
                                    </div>
                                </article>
                            </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
        </div>
    </div>
</section>

<!-- /RELATED PRODUCT -->
<?php get_footer(); ?>