<?php 
//Template Name: Ballina
get_header();
 ?>
<section class="hero_slider" id="hero_slider">
    <div class="owl-carousel">
        <?php 
        $args = array(
            'posts_per_page'=>3,
            'post_type'=>'slider',
            'meta_query' => array(
                array(
                    'key' => 'shfaq_ne_balline',
                    'value' => '1',
                    'compare' => '=='
                )
            )
        );
        $i = 0;
        $mainSlider = new WP_Query( $args );
        while ( $mainSlider->have_posts() ) : $mainSlider->the_post(); $i++;
        $sliderTitle = get_the_title();
        ?>
        <div>
            <div class="slider_item">
                <div class="slider_thumb"><?php the_post_thumbnail(); ?></div>
                <div class="slider_content">
                    <h2><?php echo $sliderTitle; ?></h2>
                </div>
            </div>
        </div>
    <?php endwhile; ?>
    <?php wp_reset_query(); ?>
    </div>
</section>
<!-- Services -->
<section class="services_section wow fadeInUp" data-wow-delay="100ms">
    <div class="container_clear">
        <div class="container has_gutter">
            <div class="section_headline">
                <h2>Shërbimet Tona</h2></div>
            <div class="service_col_wrapper">
            <?php if( have_rows('sherbimet') ): ?>
                <?php
                $i = 0;
                 while( have_rows('sherbimet') ): the_row(); 
                $serviceIcon = get_sub_field('ikona_e_sherbimit');
                $serviceTitle = get_sub_field('titulli_i_sherbimit');
                $serviceText = get_sub_field('pershkrimi_i_sherbimit');
                $i+=2;
                ?>
                <div class="column-4 column-mob-12 wow fadeInUp" data-wow-delay="<?php echo $i; ?>00ms">
                    <div class="service_col">
                        <div class="service_icon">
                            <span aria-hidden="true" class="<?php echo $serviceIcon ?>"></span>
                        </div>
                        <div class="service_content">
                            <h3><?php echo $serviceTitle; ?></h3>
                            <h4><?php echo $serviceText ?></h4>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<!-- /Services -->
<!-- About us -->
<section class="about_us">
    <div class="section_headline">
        <h2>Për Ne</h2></div>
    <div class="container_clear">
        <div class="container has_gutter">
            <div class="row">
                <?php
                    $homeAboutText = get_field('texti_per_ne_ne_balline');
                    $homeAboutImageObject = get_field('fotografia_per_ne_ne_balline');
                    $homeAboutImageSize = '600x600';
                    $homeAboutImage = $homeAboutImageObject['sizes'][$homeAboutImageSize];

                ?>
                <div class="column-6 column-mob-12 wow fadeInLeft" data-wow-delay="100ms">
                    <div class="about_thumb">
                        <img src="<?php echo $homeAboutImage; ?>" alt="about_1">
                    </div>
                </div>
                <div class="column-6 column-mob-12 wow fadeInRight" data-wow-delay="100ms">
                    <div class="about_content">
                        <?php echo $homeAboutText; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /About us -->
<!-- Numbers Section -->
<section class="numbers_section">
    <div class="section_headline">
        <h2>Statistka Rreth Neve</h2></div>
    <div class="statistic_wrapper">
        <div class="container">
        <?php $citiesNr = get_field('numri_i_qyteteve'); ?>
            <div class="column-4 column-mob-12 num_col wow fadeInUp" data-wow-delay="100ms">
                <div class="numbers_wrapper">
                    <h3><?php echo $citiesNr; ?></h3>
                    <span>Qytete</span>
                </div>
            </div>
            <div class="column-4 column-mob-12 num_col wow fadeInUp" data-wow-delay="200ms">
            <?php 
              $nrBrands = wp_count_terms( 'brend' ); 
              $nrProducts = wp_count_posts( 'produktet' ); 
             ?>
                <div class="numbers_wrapper">
                    <h3><?php echo $nrBrands; ?></h3>
                    <span>Brende</span>
                </div>
            </div>
            <div class="column-4 column-mob-12 num_col wow fadeInUp" data-wow-delay="300ms">
                <div class="numbers_wrapper">
                    <h3><?php echo $nrProducts->publish; ?></h3>
                    <span>Produkte</span>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /Numbers Section -->
<!-- Selected Brands -->
<section class="selected_brands">
    <div class="section_headline">
        <h2>Partneret</h2></div>
    <div id="brands_slider" class="brands_slider wow fadeIn" data-wow-delay="100ms">
        <div class="container has_gutter">
            <div class="row">
                <div class="owl-carousel">
                <?php 
                //logo_e_brendit
                $brandTerm = get_terms('brend',array( 'hide_empty' => false, 'parent' => 0 ));
                 ?>
                <?php 
                 foreach ($brandTerm as $term) {
                    $image = get_field('logo_e_brendit', $term->taxonomy . '_' . $term->term_id);

                       echo '
                       <div>
                           <div class="logo_wrap column-12 column-mob-12 column-tab-12 column-tab-big-12">
                                <img src="'.$image['sizes']['500x500'].'" alt="'.$term->slug.'">
                           </div>
                       </div>
                       ';
                    }
                 ?> 
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /Selected Brands -->
<!-- Sale Products -->
<section class="related_section sale_section wow fadeIn" data-wow-delay="400ms">
    <div class="container has_gutter">
        <div class="section_headline">
        <h2>Në Zbritje</h2></div>
        <div class="row">
            <?php 
                $args = array(
                    'post_type'=>'produktet',
                    'posts_per_page'=>4,
                    'meta_query' => array(
                                array(
                                    'key' => 'eshte_ne_zbritje',
                                    'value' => '1',
                                    'compare' => '=='
                                )
                            )
                );
                $i = 0;
                $prodLoop = new WP_Query( $args );
                while ( $prodLoop->have_posts() ) : $prodLoop->the_post(); $i++;
                $catSlug = get_the_terms( get_the_id(), 'kategoria_e_produktit' );
                            $brendSlug = get_the_terms( get_the_id(), 'brend' );
                            $price = get_field('cmimi');
                            $barcode = get_field('barkodi');
                            $salePrice = get_field('cmimi_ne_zbritje');
                            $isSale = get_field('eshte_ne_zbritje');
                        ?>
                    <?php if($isSale){ ?>
                            <div class="column-3 column-mob-12 column-tab-6 column-tab-big-6 is-sale grid-item <?php echo $catSlug[0]->slug ?> <?php echo $brendSlug[0]->slug ?>">
                        <?php } else {  ?>
                            <div class="column-3 column-mob-12 column-tab-6 column-tab-big-6 grid-item <?php echo $catSlug[0]->slug ?> <?php echo $brendSlug[0]->slug ?>">
                        <?php } ?>
                                <article class="brand_item">
                                    <div class="brand_holder">
                                    <?php if($isSale){ echo '<span class="zbritje-tag">Zbritje</span>'; }?>
                                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('350x350'); ?></a>
                                    </div>
                                    <div class="brand_content">
                                    <a href="<?php the_permalink(); ?>">
                                        <h4><?php the_title(); ?></h4>
                                        <p><?php echo limit(wp_strip_all_tags(get_the_content()),117) ?></p>
                                        <ul>
                                        <?php if(!$isSale){ ?>
                                        <?php if($price){ ?>
                                            <li><h5>Çmimi</h5><span><?php echo $price ?>&euro;</span></li>
                                         <?php } ?>   
                                         <?php } else { ?>
                                         <?php if($price){ ?>
                                            <li><h5>Çmimi</h5><span><strike><?php echo $price ?></strike><span class="price_sale"><?php echo $salePrice ?>&euro;</span></span></li>
                                         <?php } ?>   
                                         <?php } ?>
                                         <?php if($barcode){ ?>
                                            <li><h5>Barkodi</h5><span><?php echo $barcode; ?></span></li>
                                        <?php } ?>
                                            
                                        </ul>
                                        </a>
                                    </div>
                                </article>
                            </div>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
        </div>
    </div>
</section>
<!-- /Sale Products -->
<!-- Lajmet e Fundit -->
<section class="latest_news">
    <div class="section_headline">
        <h2>Lajmet e Fundit</h2></div>
    <div class="container_clear">
        <div class="container has_gutter">
            <div class="row">
            <?php 
                $args = array(
                    'posts_per_page'=>3,
                    'post_type'=>'post',
                    'cat'=>6
                );
                $i = 0;
                $newsLoop = new WP_Query( $args );
                while ( $newsLoop->have_posts() ) : $newsLoop->the_post(); $i++;

            ?>
                <div class="column-4 column-mob-12 column-tab-6 column-tab-big-6 wow fadeInUp" data-wow-delay="<?php echo $i?>00ms">
                    <article class="news_item">
                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?> - Arikulli i Plote">
                            <div class="news_thumb">
                                <?php the_post_thumbnail('350x180'); ?>
                             </div>
                        </a>
                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?> - Arikulli i Plote">
                            <div class="news_content">
                                <span class="post_date"><?php echo get_the_date('d/m/Y'); ?></span>
                                <h3><?php the_title(); ?></h3>
                                <p><?php echo limit(wp_strip_all_tags(get_the_content()),117); ?></p>
                            </div>
                        </a>
                        <a class="read_more" href="<?php the_permalink(); ?>" title="<?php the_title(); ?> - Arikulli i Plote">Me Shume</a>
                    </article>
                </div>
            <?php endwhile; ?>
            </div>
        </div>
    </div>
</section>
<!-- /Lajmet e Fundit -->
<!-- Clients -->
<span class="crossed_shape two"></span>
<section class="clients_wrap">
    <div class="section_headline">
        <h2>Klientet Tane</h2></div>
    <div class="container_clear">
        <div class="container has_gutter">
            <div class="row flex-container">
            <?php 
                $args = array(
                    'posts_per_page'=>-1,
                    'post_type'=>'klientat',
                );
                $i = 0;
                $clientLoop = new WP_Query( $args );
                while ( $clientLoop->have_posts() ) : $clientLoop->the_post(); $i++;
                $clientLink = get_field('uebfaqja_e_klientit');

            ?>
                <div class="client_col column-3 column-mob-12 column-tab-6 column-tab-big-6 wow fadeIn" data-wow-delay="<?php echo $i; ?>00ms">
                <?php if($clientLink){ ?>
                <a href="<?php echo $clientLink ?>" target="_blank" title="<?php the_title(); ?> - Web">
                <?php } else { ?>
                <a href="javascript:void(0)">
                <?php } ?>
                    <div class="client_logo"><?php the_post_thumbnail('350x350'); ?></div>
                </a>
                </div>
            <?php endwhile; ?>
            </div>
        </div>
    </div>
</section>
<!-- /Clients -->
<?php get_footer(); ?>