<?php 
//Template Name: Brendet
get_header();
 ?>
 <?php
  $brands = get_terms('brend',array('fields'=>'all'));
  $featuredTerms = array();

  foreach ($brands as $brand ) {
    $brandFeatured = get_field('brend_i_perzgjedhur', 'brend' . '_' . $brand->term_id);
    if($brandFeatured){     
        $featuredTerms[] = $brand;
    }
  }
  ?>
<div class="section_headline brands_headline">
    <div class="container">
        <h1>Brendet e perzgjedhura</h1>
        <?php while(have_posts()): the_post(); ?>
        <p><?php echo wp_strip_all_tags(get_the_content()); ?></p>
        <?php endwhile; ?>
    </div>
</div>
<?php  $i=1; foreach ($featuredTerms as $featured):   ?>
<?php 
    $image = get_field('logo_e_brendit', $featured->taxonomy . '_' . $featured->term_id); 
    $brandBg = get_field('brand_bg', $featured->taxonomy . '_' . $featured->term_id); 
    $termDesc = term_description($featured->term_id);

?>

<section class="product_section <?php echo ($i % 2 == 0) ? 'section_right': ''; ?>" style="background-image:-webkit-linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), url(<?php echo $brandBg; ?>);
background-image: linear-gradient( rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), url(<?php echo $brandBg; ?>);}">
    <div class="container has_gutter">
        <div class="row">
            <div class="column-5 column-tab-6 column-tab-big-6 column-mob-12 left_col wow <?php echo ($i % 2 == 0) ? 'fadeInRight': 'fadeInLeft'; ?> " data-wow-delay="100ms">
                <div class="brand_logo_wrap">
                    <?php echo '<img src="'.$image['sizes']['500x500'].'" alt="'.$featured->slug.'">' ?>
                </div>
            </div>
            <div class="column-7 column-tab-6 column-tab-big-6 column-mob-12 right_col wow <?php echo ($i % 2 == 0) ? 'fadeInLeft': 'fadeInRight'; ?>" data-wow-delay="300ms">
                <div class="brand_content_holder">
                    <h2><?php echo $featured->name; ?></h2>
                    <?php  echo $termDesc;  ?>
                    <ul class="sub_brands">
                    <?php 
                        $args = array(
                            'posts_per_page'=>5,
                            'post_type'=>'produktet',
                            'taxonomy' => 'brend',
                            'term' => $featured->slug,
                            'meta_query' => array(
                                array(
                                    'key' => 'produkt_i_perzgjedhur',
                                    'value' => '1',
                                    'compare' => '=='
                                )
                            )
                        );
                        $j = 0;
                        $prodLoop = new WP_Query( $args );
                        while ( $prodLoop->have_posts() ) : $prodLoop->the_post(); $j++;
                        ?>
                    <li>
                        <a href="<?php the_permalink(); ?>">
                            <article class="sub_brand_logo">
                                <?php the_post_thumbnail('100x100') ?>
                                <h5><?php the_title(); ?></h5>
                            </article>
                        </a>
                    </li>
                <?php endwhile;  ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $i++; endforeach; ?>

 <?php get_footer(); ?>