<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Intercoom
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="apple-touch-icon" sizes="57x57" href="<?php echo get_template_directory_uri(); ?>/icon/apple-icon-57x57.png">
<link rel="apple-touch-icon" sizes="60x60" href="<?php echo get_template_directory_uri(); ?>/icon/apple-icon-60x60.png">
<link rel="apple-touch-icon" sizes="72x72" href="<?php echo get_template_directory_uri(); ?>/icon/apple-icon-72x72.png">
<link rel="apple-touch-icon" sizes="76x76" href="<?php echo get_template_directory_uri(); ?>/icon/apple-icon-76x76.png">
<link rel="apple-touch-icon" sizes="114x114" href="<?php echo get_template_directory_uri(); ?>/icon/apple-icon-114x114.png">
<link rel="apple-touch-icon" sizes="120x120" href="<?php echo get_template_directory_uri(); ?>/icon/apple-icon-120x120.png">
<link rel="apple-touch-icon" sizes="144x144" href="<?php echo get_template_directory_uri(); ?>/icon/apple-icon-144x144.png">
<link rel="apple-touch-icon" sizes="152x152" href="<?php echo get_template_directory_uri(); ?>/icon/apple-icon-152x152.png">
<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_template_directory_uri(); ?>/icon/apple-icon-180x180.png">
<link rel="icon" type="image/png" sizes="192x192" href="<?php echo get_template_directory_uri(); ?>/icon/android-icon-192x192.png">
<link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_template_directory_uri(); ?>/icon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="<?php echo get_template_directory_uri(); ?>/icon/favicon-96x96.png">
<link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_template_directory_uri(); ?>/icon/favicon-16x16.png">
<link rel="manifest" href="<?php echo get_template_directory_uri(); ?>/icon/manifest.json">
<meta name="msapplication-TileColor" content="#ffffff">
<meta name="msapplication-TileImage" content="<?php echo get_template_directory_uri(); ?>/icon/ms-icon-144x144.png">
<meta name="theme-color" content="#00903b">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<!-- SITE HEADER -->
<header id="header" class="main_header">
    <div class="container">
        <div class="headerWrap">
            <a href="<?php echo home_url('/') ?>" id="logo" class="logo"><img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt="intercoom"></a>
            <div class="hamburger hamburger--emphatic nav_toggle show-mob" id="nav_toggle">
                <div class="hamburger-box">
                    <div class="hamburger-inner"></div>
                </div>
            </div>
            <nav class="primary_navigation">
                <?php wp_nav_menu( array( 'container'=> 'ul', 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>
                <a href="#" id="search_toggle" class="search_toggle"><span aria-hidden="true" class="icon_search"></span></a>
            </nav>
        </div>
    </div>
    <div class="search_wrap">
        <form action="<?php echo home_url('/') ?>" class="search_form">
            <input type="text" placeholder="Kerko" name="s">
            <input type="submit" value="">
            <span aria-hidden="true" class="icon_search src_ic"></span>
        </form>
    </div>
    <h1 class="screen-reader-text">Intercoom SHPK</h1>
</header>
    <!-- /SITE HEADER -->
    <!-- MAIN CONTENT -->
    <main id="main">
        <div class="mainWrap">
