<?php
/**
 * Intercoom functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Intercoom
 */

if ( ! function_exists( 'intercoom_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function intercoom_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Intercoom, use a find and replace
	 * to change 'intercoom' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'intercoom', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_image_size('600x600',600,600,true);
	add_image_size('350x180',350,180,true);
	add_image_size('300x300',300,300,true);
	add_image_size('1200x460',1200,460,true);
	add_image_size('500x500',500,9999,false);
	add_image_size('200x200',200,9999,false);
	add_image_size('450x290',450,9999,false);
	add_image_size('350x350',350,9999,false);	
	add_image_size('100x100',100,9999,false);
	add_image_size('120x88',120,88,true);

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'intercoom' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'intercoom_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
}
endif;
add_action( 'after_setup_theme', 'intercoom_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function intercoom_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'intercoom_content_width', 640 );
}
add_action( 'after_setup_theme', 'intercoom_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function intercoom_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'intercoom' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'intercoom' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'intercoom_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function intercoom_scripts() {
	wp_enqueue_style( 'intercoom-style', get_template_directory_uri().'/dist/app.min.css' );
	//Scripts
	wp_enqueue_script( 'intercoom-scripts', get_template_directory_uri() . '/dist/app.min.js', array(), '1', true );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'intercoom_scripts' );
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
//Gallery
require get_template_directory() . '/inc/gallery.php';
//Customs
//Reg Footer Nav
function register_footer_menu() {
  register_nav_menu('footer-nav',__( 'Footer Navigation' ));
}

add_action( 'init', 'register_footer_menu' );


//Reg Mobile nav
function register_mobile_menu() {
  register_nav_menu('mobile-nav',__( 'Mobile Navigation' ));
}
add_action( 'init', 'register_mobile_menu' );
//Limit Function for content
function limit($value, $limit = 100, $end = '...') {
 if (strlen($value) <= $limit) return $value;
 return mb_substr($value, 0, $limit).$end;
}
if( function_exists('acf_add_options_page') ) {
	
	acf_add_options_page(array(
		'page_title' 	=> 'Opsionet Gjenerale te Faqes',
		'menu_title'	=> 'Opsionet Gjenerale',
	));
	
}
function custom_login_logo() {
	echo '<style type="text/css">h1 a { background: url('.get_bloginfo('template_directory').'/images/logo.png) 50% 50% no-repeat !important; width:264px !important;}</style>';
}
add_action('login_head', 'custom_login_logo');
function change_wp_login_title() {
	return get_option('blogname');
}
add_filter('login_headertitle', 'change_wp_login_title');
function my_loginURL() {
    return 'https://www.intercoom.com';
}
add_filter('login_headerurl', 'my_loginURL');

function insert_fb_in_head() {
    $og_metatags = '';
    if(is_home() || is_front_page()){
        $url = get_template_directory_uri().'/images/facebook_image.png';
        $og_metatags .= '<meta property="og:title" content="'.get_bloginfo('name').'" />';
        $og_metatags .= '<meta property="og:description" content="Kompania Intercoom  është lidere në Kosovë në fushën e shpërndarjes dhe shitjes së mallrave higjienike, karikuese(bateria). Ne bazë të organizimit të mirëfillt dhe përkushtimit të vazhdueshëm për efikasitet në punë, teknologji të avancuar, orientim të sinqertë kah blerësi, si dhe në bazë të kontributit të punonjësve të kualifikuar me përkushtim të mirëfillt, të cilët janë të punësuar në ketë kompani, janë arritur suksese shumë të larta dhe të qëndrueshme." />';
        $og_metatags .= '<meta property="og:image:width" content="500" />';
        $og_metatags .= '<meta property="og:image:height" content="500" />';
        $og_metatags .= '<meta property="og:image" content="'.$url.'" />';
        $og_metatags .= '<meta property="og:type" content="website" />';
        $og_metatags .= '<meta property="og:url" content="'.home_url().'" />';
    }else{
        $url = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );   
        $excerpt = strip_tags(get_the_excerpt());
        $og_metatags .= '<meta property="og:title" content="'.strip_tags(get_the_title()).'" />';
        $og_metatags .= '<meta property="og:description" content="'.( (!empty($excerpt)) ? $excerpt : limit(strip_tags(get_post_field('post_content', get_the_ID())),200) ).'" />';
        $og_metatags .= '<meta property="og:image" content="'.$url.'" />';
        $og_metatags .= '<meta property="og:type" content="article" />';
        $og_metatags .= '<meta property="og:url" content="'.get_permalink().'" />';
        $og_metatags .= '<meta name="twitter:title" content="'.strip_tags(get_the_title()).'" />';
        $og_metatags .= '<meta name="twitter:description" content="'.strip_tags(get_the_excerpt()).'" />';
        $og_metatags .= '<meta name="twitter:image" content="'.$url.'" />';
        $og_metatags .= '<meta name="twitter:card" content="summary_large_image" />';
        $og_metatags .= '<meta name="twitter:site" content="@Intercoom" />';
        $og_metatags .= '<meta name="twitter:creator" content="@Intercoom" />';        
    }
    echo $og_metatags;
}
add_action( 'wp_head', 'insert_fb_in_head', 5 );