<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Intercoom
 */

?>	
</div>
</main>
<!-- /MAIN CONTENT -->
    <!-- SITE FOOTER -->
<footer id="footer" class="main_footer">
    <div class="footerWrap">
        <div class="container has_gutter">
            <div class="row">
            <?php 
                $tel = get_field('numri_i_telefonit', 'option');
                $email = get_field('email', 'option');
                $adresa = get_field('adresa', 'option');
                $facebook = get_field('facebook', 'option');
                $twitter = get_field('twitter', 'option');
                $linkedin = get_field('linkedin', 'option');
                $endText = wp_strip_all_tags(get_field('texti_ne_fund', 'option'));
             ?>
                <div class="footer_col_wrap column-3 column-mob-12">
                    <div class="footer_col">
                        <h3>Zyret dhe Kontakti</h3>
                        <ul>
                        <?php if($tel){ ?>
                            <li><span aria-hidden="true" class="icon_mobile"></span><span class="col_info"><?php echo $tel; ?></span></li>
                        <?php } ?>
                        <?php if($email){ ?>
                            <li><span aria-hidden="true" class="icon_mail_alt"></span><span class="col_info"><a style="color:white;" target="_blank" href="mailto:<?php echo $email ?>"><?php echo $email ?></a></span></li>
                        <?php } ?>
                        <?php if($adresa) { ?>
                            <li><span aria-hidden="true" class="icon_pin_alt"></span><span class="col_info"><?php echo $adresa ?></span></li>
                        <?php } ?>
                        </ul>
                    </div>
                </div>
                <div class="footer_col_wrap column-3 column-mob-12">
                    <div class="footer_col">
                        <h3>Sitemap</h3>
                        <nav>
                        <?php wp_nav_menu( array( 'container'=> 'ul', 'theme_location' => 'footer-nav', 'menu_id' => 'footer-menu', 'menu_class' => 'nav_footer' ) ); ?>
                        </nav>
                    </div>
                </div>
                <div class="footer_col_wrap column-3 column-mob-12">
                    <div class="footer_col">
                        <h3>Na Ndiqni</h3>
                        <ul class="social_footer">
                        <?php if($facebook){ ?>
                            <li><a href="<?php echo $facebook ?>" target="_blank"><span aria-hidden="true" class="social_facebook_circle"></span></a></li>
                        <?php } ?>
                        <?php if($twitter){ ?>
                            <li><a href="<?php echo $twitter ?>" target="_blank"><span aria-hidden="true" class="social_twitter_circle"></span></a></li>
                        <?php } ?>
                        <?php if($linkedin){ ?>
                            <li><a href="<?php echo $linkedin ?>" target="_blank"><span aria-hidden="true" class="social_linkedin_circle"></span></a></li>
                        <?php } ?>
                        </ul>
                    </div>
                </div>
                <div class="footer_col_wrap column-3 column-mob-12">
                    <div class="footer_col">
                        <h3>Rreth Nesh</h3>
                        <a href="<?php echo home_url('/') ?>" ><img src="<?php echo get_template_directory_uri(); ?>/images/logo_white.png" alt="Logo" class="footer_logo"></a>
                        <?php if($endText){ ?>
                        <p class="small_text"><?php echo $endText ?></p>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <span class="cpr">Copyright © 2016 Intercoom ®</span>
    </div>
</footer>
<!-- /SITE FOOTER -->
<script src="https://ajax.googleapis.com/ajax/libs/webfont/1.5.18/webfont.js"></script>
<script>
WebFont.load({
    google: {
        families: ['Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i']
    }
});
</script>

<?php wp_footer(); ?>

</body>
</html>
