<?php get_header(); ?>
<!-- PRODUCT ARCHIVE -->
<section class="products_section">
    <div class="section_headline">
        <h1>Produktet</h1>
    </div>
    <div class="container_clear">
        <div class="container has_gutter">
            <div class="row">
                <div class="column-3 column-mob-12 column-tab-5 column-tab-big-4 wow fadeInLeft" data-wow-delay="100ms">
                    <div class="brand_filter_wrap" style="margin-bottom: 20px;">
                        <h4>Kategoritë</h4>
                        <ul class="brand_filter" data-filter-group="cat">
                        <?php $catTerm = get_terms(array(
                            'taxonomy'=>'kategoria_e_produktit',
                            'hierarchical'=>false
                            )); ?>
                            <li class="active_filter"><a href="#" data-filter="*">Të Gjitha</a></li>
                            <?php 
							foreach ($catTerm as $term2) {
								echo '<li><a href="#" data-filter=".'.$term2->slug.'">'.$term2->name.'</a></li>';
							}
							?> 
                        </ul>
                    </div>
                    <div class="brand_filter_wrap">
                        <h4>Brendet</h4>
                        <ul class="brand_filter" data-filter-group="brand">
                        <?php $brandTerm = get_terms(array(
                            'taxonomy'=>'brend',
                        )); ?>
                            <li class="active_filter"><a href="#" data-filter="*">Të Gjitha</a></li>
							<?php 
							foreach ($brandTerm as $term) {
								echo '<li><a href="#" data-filter=".'.$term->slug.'">'.$term->name.'</a></li>';
							}
							?> 
                        </ul>
                    </div>
                </div>
                <div class="column-9 column-mob-12 column-tab-7 column-tab-big-8 wow fadeInRight" data-wow-delay="100ms">
                    <div class="row">
                        <div class="brands_grid" id="brand_grid">
						<?php 
						$args = array(
							'posts_per_page'=>-1,
							'post_type'=>'produktet'
						);
						$i = 0;
						$prodLoop = new WP_Query( $args );
						while ( $prodLoop->have_posts() ) : $prodLoop->the_post(); $i++;
							$catSlug = get_the_terms( get_the_id(), 'kategoria_e_produktit' );
							$brendSlug = get_the_terms( get_the_id(), 'brend' );
                            $price = get_field('cmimi');
                            $barcode = get_field('barkodi');
                            $salePrice = get_field('cmimi_ne_zbritje');
                            $isSale = get_field('eshte_ne_zbritje');
						?>
                        <?php if($isSale){ ?>
                            <div class="column-4 column-mob-12 column-tab-6 column-tab-big-6 is-sale grid-item <?php foreach( $catSlug as $ct ) echo ' ' . $ct->slug; ?> <?php foreach( $brendSlug as $bs ) echo ' ' . $bs->slug; ?>">
                        <?php } else {  ?>
                            <div class="column-4 column-mob-12 column-tab-6 column-tab-big-6 grid-item <?php foreach( $catSlug as $ct ) echo ' ' . $ct->slug; ?> <?php foreach( $brendSlug as $bs ) echo ' ' . $bs->slug; ?>">
                        <?php } ?>
                                <article class="brand_item">
                                    <div class="brand_holder">
                                    <?php if($isSale){ echo '<span class="zbritje-tag">Zbritje</span>'; }?>
                                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('350x350'); ?></a>
                                    </div>
                                    <div class="brand_content">
                                    <a href="<?php the_permalink(); ?>">
                                        <h4><?php the_title(); ?></h4>
                                        <p><?php echo limit(wp_strip_all_tags(get_the_content()),117) ?></p>
                                        <ul>
                                        <?php if(!$isSale){ ?>
                                        <?php if($price){ ?>
                                            <li><h5>Çmimi</h5><span><?php echo $price ?>&euro;</span></li>
                                         <?php } ?>   
                                         <?php } else { ?>
                                         <?php if($price){ ?>
                                            <li><h5>Çmimi</h5><span><strike><?php echo $price ?></strike><span class="price_sale"><?php echo $salePrice ?>&euro;</span></span></li>
                                         <?php } ?>   
                                         <?php } ?>
                                         <?php if($barcode){ ?>
                                            <li><h5>Barkodi</h5><span><?php echo $barcode; ?></span></li>
                                        <?php } ?>
                                            
                                        </ul>
                                        </a>
                                    </div>
                                </article>
                            </div>
                        <?php endwhile; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /PRODUCT ARCHIVE -->
<?php get_footer(); ?>